 ; Ŀ
 ;   Beav - make a beaver stamp.                                           
 ;   Copyright 2001, 2008 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Aang - find the included angle of an arc.                  
 ;   Arguments: Arclen, the arc length.                                    
 ;              Arcrad, the arc radius.                                    
 ;   Returns an angle in radians.                                          
 ; 
 (DEFUN AANG (arclen arcrad)
 ; Ŀ
 ;   Get the circumference of a circle with the same radius as the arc.    
 ; 
;  (setq circum (* pi 2 arcrad))
 ; Ŀ
 ;   Divide the arc length by the circumference.                           
 ; 
;  (setq fraca (/ arclen circum))
 ; Ŀ
 ;   Multiply that fraction by 2pi radians.                                
 ; 
;  (setq angg (* fraca pi 2))
 ; Ŀ
 ;   But if one cancels out the 2pi one is left with this.                 
 ; 
 (/ arclen arcrad))
 ; Ŀ
 ;   Subroutine Aang end.                                                  
 ; 

 ; Ŀ
 ;   Arcsin - Find an angle given the sine thereof.                        
 ;   Arguments: Sang, The sine of the desired angle.                       
 ;   Calls nothing, returns an angle (in radians.)                         
 ; 
 (DEFUN ARCSIN (sang / cang tang orang)
 ; Ŀ
 ;   Get Cos from Sin: Sin^2 + Cos^2 = 1.                                  
 ; 
  (setq cang (sqrt (abs (- 1 (* sang sang)))))
 ; Ŀ
 ;   Tan = Sin/Cos.                                                        
 ; 
  (setq tang (/ sang cang))
 ; Ŀ
 ;   Arctan = -Tan = the original angle.                                   
 ; 
  (setq orang (atan tang))
 orang)
 ; Ŀ
 ;   Arcsin end.                                                           
 ; 

 ; Ŀ
 ;   Beaver.                                                               
 ; 
 (DEFUN BEAVER (pa bstr / enam bstrln arcang endpt stangl wlist sub chra ptxt
                                                            txang widd anginc)
 ; Ŀ
 ;   Find the length of the name string.                                   
 ; 
  (setq enam (matext (getvar "viewctr") "." 2 "standard" 0))
  (setq bstrln (rile bstr enam))
  (entdel enam)
 ; Ŀ
 ;   Find the endpoints of the arc which will contain the text.            
 ;   The arc radius is 11.4.                                               
 ; 
  (setq arcang (aang bstrln 11.4))
  (setq endpt (polar pa (+ (/ pi 2) (/ arcang 2)) 11.4))
 ; (grdraw pa endpt 1)
  (setq stangl (+ (/ pi 2) (/ arcang 2)))
 ; Ŀ
 ;   Make a list of each letter and its width.                             
 ;   Add the spaces between each two letters.                              
 ; 
  (setq wlist (chalen bstr 2))
 ; Ŀ
 ;   Process the list.                                                     
 ; 
  (while (setq sub (car wlist))
         (setq wlist (cdr wlist))
         (setq chra (car sub))
         (setq ptxt (polar pa stangl 11.4))
 ;       (grdraw pa ptxt 251)
         (setq txang (* (- stangl (/ pi 2)) (/ 180 pi)))
 ; Ŀ
 ;   Make a text entity if the sublist isn't just an angle.                
 ;   Otherwise the single element in the list will be an angle, so move    
 ;   the value into the width variable.                                    
 ; 
         (if (setq widd (cdr sub))
             (matext ptxt chra 2 "standard" txang)
             (setq widd chra))
 ; Ŀ
 ;   Calculate the angle the text entity occupies, add that to the base    
 ;   angle, calculate a new text angle.                                    
 ; 
         (setq anginc (arcsin (/ widd 11.4)))
         (setq stangl (- stangl anginc)))
 (princ))
 ; Ŀ
 ;   Beaver end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Bmake: make a block of an ss, insert it.                   
 ;   Arguments, ss, a selection set.                                       
 ;              Bnam, the desired block name.                              
 ;              Pa, a point.                                               
 ;              Inso, Insert at pa if t.                                   
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BMAKE (ss bnam pa inso)
  (if (tblsearch "block" bnam)
      (command ".block" bnam "y" pa ss "")
      (command ".block" bnam pa ss ""))
  (if inso (command ".insert" bnam pa 1 "" 0))
 (princ))
 ; Ŀ
 ;   Subroutine Bmake end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Chalen - make a text string into a list of                 
 ;   ((character width) ...).                                              
 ;   Arguments: Stra, a string.                                            
 ;              Txht, the proposed text height.                            
 ;   Calls Matext and Rile.                                                
 ;   Returns a list.                                                       
 ; 
 (DEFUN CHALEN (stra txht / enam len pos chra spwid sub wlist chwid chrb)
  (setq enam (matext (getvar "viewctr") "." txht "standard" 0))
  (setq len (strlen stra))
  (setq pos 1)
  (while (<= pos len)
         (setq chra (substr stra pos 1))
         (setq pos (1+ pos))
 ; Ŀ
 ;   Calculate and add the space between letters.                          
 ; 
         (if (and chra chrb)
             (progn
                  (setq spwid (spach chra chrb txht))
                  (setq sub (list spwid))
                  (setq wlist (cons sub wlist))))
         (setq chwid (rile chra enam))
         (setq sub (cons chra chwid))
         (setq wlist (cons sub wlist))
         (setq chrb chra))
  (entdel enam)
 (reverse wlist))
 ; Ŀ
 ;   Chalen end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Matext - make a text entity.                               
 ;   Arguments: Pa, the insertion point.                                   
 ;              Stra, a string.                                            
 ;              Txht, the proposed text height.                            
 ;              Styl, the style.                                           
 ;              Rota, the rotation angle.                                  
 ;   Calls nothing.                                                        
 ;   Returns an entity name.                                               
 ; 
 (DEFUN MATEXT (pa stra txht styl rota / fh entt)
  (setq fh (cdr (assoc 40 (tblsearch "style" styl))))  ; is it fixed height?
  (if (= fh 0.0)
      (command "text" "s" styl pa txht rota stra)      ; no
      (progn
           (command "text" "s" styl pa rota stra)      ; yes
           (setq entt (entget (entlast)))
           (entmod (subst (cons 40 txht) (assoc 40 entt) entt))))
 (entlast))
 ; Ŀ
 ;   Matext end.                                                           
 ; 

 ; Ŀ
 ;   Rile - find the width of a text entity by converting it to right      
 ;   justification and measuring the distance between its ten and eleven   
 ;   points.                                                               
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   Arguments: Str - the string to measure.                               
 ;              Enam - the ename of an entity having the properties        
 ;              which we require in the string.                            
 ;   Calls nothing, returns a distance.                                    
 ;   Not as simple as the textbox function, but doesn't return zero as     
 ;   the width of a space, which textbox now does - this must be a new     
 ;   paradigm or something.                                                
 ;   This returns a length of zero for an empty string, by the way.        
 ; 
 (DEFUN RILE (str enam / entt typp dist)
  (setq entt (entget enam))
  (if (member (setq typp (cdr (assoc 0 entt))) '("TEXT" "ATTDEF"))
      (progn
           (command ".copy" enam "" "0,0" "0,0")
           (setq entt (entget (setq enam (entlast))))
           (if (= typp "TEXT")
               (setq entt (subst (cons 1 str) (assoc 1 entt) entt))
               (setq entt (subst (cons 2 str) (assoc 2 entt) entt)))
           (entmod (subst (cons 72 2) (assoc 72 entt) entt))    ; change
           (setq entt (entget enam))                 ; get the changed edata
           (setq dist (distance (cdr (assoc 10 entt)) (cdr (assoc 11 entt))))
           (entdel enam)))
 dist)
 ; Ŀ
 ;   Rile end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Smack - make an ss of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns an ss.                 
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMACK (aaa / ss bbb)
  (setq ss (ssadd (setq bbb (entnext aaa)))) ; put next ent in new ss
 ; Ŀ
 ;   If the entity is an insert and has attributes, or is a polyline:      
 ; 
  (if (or (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
               (= (cdr (assoc 66 (entget bbb))) 1))
          (= (cdr (assoc 0 (entget bbb))) "POLYLINE"))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (entnext bbb)                  ; while there are entities
         (setq bbb (entnext bbb))       ; find the next new entity
         (ssadd bbb ss)                 ; add it to the selection set
         (if (or (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                      (= (cdr (assoc 66 (entget bbb))) 1))
                 (= (cdr (assoc 0 (entget bbb))) "POLYLINE"))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
  ss)
 ; Ŀ
 ;   Smack end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Spach - find the space between two characters.             
 ;   Arguments: Chara, a character.                                        
 ;              Charb, another character.                                  
 ;   Calls Matext and Rile.                                                
 ;   Returns a length.                                                     
 ; 
 (DEFUN SPACH (chara charb txht / enam chawid chbwid chcwid)
  (setq enam (matext (getvar "viewctr") "." txht "standard" 0))
  (setq chawid (rile chara enam))
  (setq chbwid (rile charb enam))
  (setq chcwid (rile (strcat chara charb) enam))
  (entdel enam)
 (- chcwid chawid chbwid))
 ; Ŀ
 ;   Spach end.                                                            
 ; 


 ; Ŀ
 ;   Zzx - make a set of beaver stamp geometry without text.               
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN ZZX ()
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 0) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.70044 -12.3671 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -0.635498 -14.2364 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 0) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 0.349121 -12.4409 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 2.53686 -14.054 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 0) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.27466 -12.644 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 5.3147 -13.6789 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 0) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -1.25521 -0.260414 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.379926) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -1.4218 -3.68812 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0741986) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.65205 -3.58808 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.155234) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.70857 -4.04892 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.273214) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.83343 -4.42815 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.403848) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.71818 -4.50496 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0100281) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.61714 -4.50204 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0395236) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.0634 -4.27712 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0235931) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -1.42973 -4.20092 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0613834) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -0.769966 -4.23401 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0565463) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 0.753276 -4.32514 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0952885) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 1.80588 -4.26234 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0669044) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 1.93198 -4.21127 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.208228) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 2.61291 -4.13757 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 2.79402 -4.20104 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.8871 -4.56006 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 4.18442 -4.69141 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 5.58356 -5.34815 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 5.88087 -5.45323 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 6.3727 -5.61157 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.125934) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 9.38481 -5.45892 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.231848) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 9.90136 -5.01347 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.348704) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 9.86393 -4.87687 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.106806) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 9.48205 -4.70659 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0626847) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 8.88775 -4.39686 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0694925) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 8.01102 -3.95494 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0632191) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 5.72441 -3.487 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.00674088) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.39605 -3.34222 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.349732) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.1871 -3.20871 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.126442) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.17184 -3.01303 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.00677483) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 3.56025 -0.609109 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.352916) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 1.68186 2.58286 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0630418) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 0.924139 2.9834 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0527613) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -0.129473 3.90305 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.13) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -0.386879 4.34956 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.00310796) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -0.620636 5.25545 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.296268) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.03979 6.54086 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.123694) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.8293 6.38621 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0938197) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.25218 6.32435 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0713088) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.8143 6.26765 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0293039) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.27844 6.12331 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.377483) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.49504 5.71606 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.124264) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.23718 5.22118 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.213982) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.20624 5.12323 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.228951) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.9948 4.51494 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0607363) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.14449 3.06463 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 0) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.74665 1.41296 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0077103) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.23 1.19917 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.17283) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.6663 1.17352 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.00698105) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.71855 1.46427 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0663742) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.09496 1.61819 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0743715) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.36872 1.72508 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.225119) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -6.30975 1.51557 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.440931) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -6.32686 1.29751 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0222863) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -6.13438 1.10938 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.108585) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.94617 0.848565 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.190685) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.74513 0.647607 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0624136) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -5.3345 0.527888 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0777024) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -4.47901 0.249967 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0881185) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.78087 -0.263116 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.281852) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -1.76371 0.205607 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.0) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "POLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDb2dPolyline") (66 . 1) (10 0.0 0.0 0.0) (70 . 1) (40 . 0.0) (41 . 0.0) (210 0.0 0.0 1.0) (71 . 0) (72 . 0) (73 . 0) (74 . 0) (75 . 0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.12464 5.94106 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.163058) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.78668 5.72542 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.587813) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.81441 5.65663 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.160298) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -2.90892 5.67511 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.017627) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.00856 5.72645 0.0) (40 . 0.0) (41 . 0.0) (42 . 0.336718) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.19038 5.69975 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0455074) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.25202 5.64225 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.755112) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.51191 5.83324 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.346671) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "VERTEX") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbVertex") (100 . "AcDb2dVertex") (10 -3.28592 5.97084 0.0) (40 . 0.0) (41 . 0.0) (42 . -0.0310434) (70 . 0) (50 . 0.0)))
    (entmake '((0 . "SEQEND") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock")))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -14.1891 8.69021 0.0) (40 . 2.9) (1 . "O") (50 . 0.943365) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -13.6054 9.49513 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 13.9957 -8.98192 0.0) (40 . 2.9) (1 . "A") (50 . 4.082) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 13.4096 -9.7851 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 15.1728 -6.79031 0.0) (40 . 2.9) (1 . "T") (50 . 4.23923) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 14.7763 -7.56472 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 16.0489 -4.33079 0.0) (40 . 2.9) (1 . "R") (50 . 4.39646) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 15.7786 -5.15773 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 16.5192 -1.82579 0.0) (40 . 2.9) (1 . "E") (50 . 4.55368) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 16.3915 -2.6235 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 16.6014 0.845458 0.0) (40 . 2.9) (1 . "B") (50 . 4.71091) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 16.6001 -0.0245411 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 16.2835 3.31171 0.0) (40 . 2.9) (1 . "L") (50 . 4.86814) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 16.3992 2.57502 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 15.4876 6.05704 0.0) (40 . 2.9) (1 . "A") (50 . 5.02537) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 15.7937 5.11105 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 12.9277 10.4497 0.0) (40 . 2.9) (1 . "R") (50 . 5.33982) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 13.4385 9.74541 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 11.1759 12.3011 0.0) (40 . 2.9) (1 . "E") (50 . 5.49705) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 11.7468 11.7294 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 9.11198 13.8993 0.0) (40 . 2.9) (1 . "E") (50 . 5.65428) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 9.76526 13.424 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 6.76787 15.1828 0.0) (40 . 2.9) (1 . "N") (50 . 5.8115) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 7.54287 14.7875 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 5.1344 15.7862 0.0) (40 . 2.9) (1 . "I") (50 . 5.96873) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 5.1344 15.7862 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 1.67861 16.5413 0.0) (40 . 2.9) (1 . "G") (50 . 6.12596) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 2.59926 16.3954 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -0.87 16.6002 0.0) (40 . 2.9) (1 . "N") (50 . 0.0) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -4.79908e-008 16.6002 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -3.39715 16.2689 0.0) (40 . 2.9) (1 . "E") (50 . 0.157227) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -2.59926 16.3954 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -8.20716 14.4487 0.0) (40 . 2.9) (1 . "L") (50 . 0.471682) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -7.54287 14.7875 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -10.5693 12.8391 0.0) (40 . 2.9) (1 . "A") (50 . 0.62891) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -9.76527 13.424 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -12.3615 11.1138 0.0) (40 . 2.9) (1 . "N") (50 . 0.786137) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -11.7468 11.7294 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -14.7986 7.521 0.0) (40 . 2.9) (1 . "I") (50 . 1.10059) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -14.7986 7.521 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -16.0616 4.28332 0.0) (40 . 2.9) (1 . "S") (50 . 1.25782) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -15.7937 5.11105 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -16.5342 1.71555 0.0) (40 . 2.9) (1 . "S") (50 . 1.41505) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -16.3992 2.57502 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -16.5989 -0.832397 0.0) (40 . 2.9) (1 . "E") (50 . 1.57227) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -16.6001 -0.0245411 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -16.2639 -3.4212 0.0) (40 . 2.9) (1 . "F") (50 . 1.7295) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -16.3915 -2.6235 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -15.4696 -6.1028 0.0) (40 . 2.9) (1 . "O") (50 . 1.88673) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -15.7786 -5.15773 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -14.3799 -8.33914 0.0) (40 . 2.9) (1 . "R") (50 . 2.04396) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -14.7763 -7.56472 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "TEXT") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbText") (10 -12.8968 -10.4879 0.0) (40 . 2.9) (1 . "P") (50 . 2.20118) (41 . 0.9) (51 . 0.0) (7 . "Standard") (71 . 0) (72 . 1) (11 -13.4096 -9.7851 0.0) (210 0.0 0.0 1.0) (100 . "AcDbText") (73 . 0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 2) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 1.89282 -13.557) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 3.27417 -12.6438) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 2) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 -1.41089 -13.4876) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 0.349121 -12.4408) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 2) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 -5.31445 -13.7949) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -2.70068 -12.367) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 3) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 -0.786133 -6.98509) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -0.786133 -8.36858) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -5.31445 -8.36858) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 3) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 0.786133 -6.98509) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 0.786133 -8.36858) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 5.31421 -8.36858) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 3) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 5.31421 -9.79274) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 0.786133 -9.79274) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 0.786133 -11.4338) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 3) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 -5.30884 -9.79274) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -0.761231 -9.79274) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -0.761231 -11.4338) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "CIRCLE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 3.46041 -16.743 0.0) (40 . 0.846846) (210 0.0 0.0 1.0)))
  (entmake '((0 . "CIRCLE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 1.0356 -16.743 0.0) (40 . 0.846846) (210 0.0 0.0 1.0)))
  (entmake '((0 . "CIRCLE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 -1.2935 -16.743 0.0) (40 . 0.846846) (210 0.0 0.0 1.0)))
  (entmake '((0 . "CIRCLE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 -3.67046 -16.7271 0.0) (40 . 0.846846) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 3.13413 -17.5245 0.0) (11 2.86401 -18.4642 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 3.84579 -17.4971 0.0) (11 4.03296 -18.4601 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 1.44502 -17.4843 0.0) (11 1.61816 -18.3752 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 0.696506 -17.519 0.0) (11 0.449219 -18.3793 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -0.947167 -17.5158 0.0) (11 -0.796631 -18.2903 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -1.72849 -17.4696 0.0) (11 -1.96558 -18.2944 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -3.31708 -17.4966 0.0) (11 -3.13306 -18.4435 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -4.02811 -17.4947 0.0) (11 -4.302 -18.4476 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -5.30225 -11.4338 0.0) (11 5.31421 -11.4338 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 10.3795 -9.80751 0.0) (11 10.3795 -8.6344 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbLine") (10 -10.2952 -8.56633 0.0) (11 -10.2952 -9.83235 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "ARC") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 -5.54419 -24.1024 0.0) (40 . 9.42975) (210 0.0 0.0 1.0) (100 . "AcDbArc") (50 . 1.17565) (51 . 1.54619)))
  (entmake '((0 . "ARC") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 -1.05493 -19.3243 0.0) (40 . 4.4233) (210 0.0 0.0 1.0) (100 . "AcDbArc") (50 . 0.966585) (51 . 1.91541)))
  (entmake '((0 . "ARC") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 3.67456 -21.02 0.0) (40 . 6.02416) (210 0.0 0.0 1.0) (100 . "AcDbArc") (50 . 1.2951) (51 . 1.9926)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 8) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 -7.44777 -9.43192) (40 . 0.0) (41 . 0.0) (42 . 0.101599) (10 -7.66343 -14.9263) (40 . 0.0) (41 . 0.0) (42 . -0.453538) (10 -8.61927 -16.0884) (40 . 0.0) (41 . 0.0) (42 . -0.253814) (10 -17.5747 -11.6767) (40 . 0.0) (41 . 0.0) (42 . -1.86561) (10 17.5683 -11.6863) (40 . 0.0) (41 . 0.0) (42 . -0.253859) (10 8.60782 -16.0914) (40 . 0.0) (41 . 0.0) (42 . -0.451714) (10 7.6582 -14.9297) (40 . 0.0) (41 . 0.0) (42 . 0.105739) (10 7.38713 -9.21813) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 19) (70 . 0) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 8.87038 -10.0439) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 8.87038 -9.24296) (40 . 0.0) (41 . 0.0) (42 . 0.140397) (10 10.2628 -8.83568) (40 . 0.0) (41 . 0.0) (42 . 0.577351) (10 10.2628 -8.43306) (40 . 0.0) (41 . 0.0) (42 . 0.11197) (10 9.1645 -8.04386) (40 . 0.0) (41 . 0.0) (42 . 0.218524) (10 7.70355 -8.4665) (40 . 0.0) (41 . 0.0) (42 . 0.57735) (10 7.70355 -9.6212) (40 . 0.0) (41 . 0.0) (42 . 0.141742) (10 8.62442 -10.0439) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 8.87085 -10.0439) (40 . 0.0) (41 . 0.0) (42 . 0.262603) (10 12.7246 -7.94292) (40 . 0.0) (41 . 0.0) (42 . 1.80305) (10 -12.7246 -7.94288) (40 . 0.0) (41 . 0.0) (42 . 0.251241) (10 -9.06133 -10.0426) (40 . 0.0) (41 . 0.0) (42 . 0.206539) (10 -7.65652 -9.62121) (40 . 0.0) (41 . 0.0) (42 . 0.57706) (10 -7.65602 -8.4668) (40 . 0.0) (41 . 0.0) (42 . 0.148381) (10 -8.64425 -8.04386) (40 . 0.0) (41 . 0.0) (42 . 0.151331) (10 -10.1797 -8.355) (40 . 0.0) (41 . 0.0) (42 . 0.57735) (10 -10.1797 -8.75762) (40 . 0.0) (41 . 0.0) (42 . 0.136065) (10 -8.82337 -9.15973) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -8.82337 -10.0548) (40 . 0.0) (41 . 0.0) (42 . 0.0) (210 0.0 0.0 1.0)))
  (entmake '((0 . "LWPOLYLINE") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbPolyline") (90 . 13) (70 . 1) (43 . 0.0) (38 . 0.0) (39 . 0.0) (10 6.2985 -6.98512) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -6.28969 -6.98544) (40 . 0.0) (41 . 0.0) (42 . -0.318436) (10 -5.30627 -8.31431) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -5.30627 -17.7918) (40 . 0.0) (41 . 0.0) (42 . 0.414213) (10 -4.0365 -19.0616) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -1.28723 -19.0616) (40 . 0.0) (41 . 0.0) (42 . -0.165637) (10 -0.678467 -19.2744) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 -0.000197048 -19.8057) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 0.678223 -19.2743) (40 . 0.0) (41 . 0.0) (42 . -0.167671) (10 1.29489 -19.0615) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 4.04416 -19.0615) (40 . 0.0) (41 . 0.0) (42 . 0.414215) (10 5.31416 -17.7915) (40 . 0.0) (41 . 0.0) (42 . 0.0) (10 5.31416 -8.33056) (40 . 0.0) (41 . 0.0) (42 . -0.321805) (210 0.0 0.0 1.0)))
  (entmake '((0 . "ARC") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 0.389434 -0.652763 0.0) (40 . 3.21414) (210 0.0 0.0 1.0) (100 . "AcDbArc") (50 . 3.01932) (51 . 3.95196)))
  (entmake '((0 . "ARC") (100 . "AcDbEntity") (8 . "0") (62 . 0) (6 . "ByBlock") (100 . "AcDbCircle") (10 -0.154424 2.81551 0.0) (40 . 3.26697) (210 0.0 0.0 1.0) (100 . "AcDbArc") (50 . 3.01493) (51 . 3.62951)))
 (princ))
 ; Ŀ
 ;   Zzx end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Beav.                                                      
 ;   Arguments: Bstr, the name string.                                     
 ;              Inso, Insert the new block if t.                           
 ;   Calls Beaver, Zzx, Smack, and Bmake.                                  
 ;   Returns nothing.                                                      
 ; 
 (DEFUN BEAV (bstr inso / *error* pa bstr kilo aaa)
  (setq pa '(0 0 0))
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Find the last entity, save its ename.                                 
 ; 
  (setq aaa (entlast))
  (if (null aaa)
      (progn
           (command "point" "0,0")
           (setq kilo (setq aaa (entlast)))))
  (while (setq bbb (entnext aaa))
         (setq aaa bbb))
 ; Ŀ
 ;   Make the name text.                                                   
 ; 
  (setvar "clayer" "0")
  (beaver pa bstr)
 ; Ŀ
 ;   Make the geometry.                                                    
 ; 
  (zzx)
 ; Ŀ
 ;   Get an ss of the new entities.                                        
 ; 
  (setq ss (smack aaa))
  (if kilo (entdel kilo))
 ; Ŀ
 ;   Make them into a block.                                               
 ; 
  (bmake ss "Beaver" pa inso)
  (*error* ())
 (princ))
 ; Ŀ
 ;   Subroutine Beav end.                                                  
 ; 

 ; Ŀ
 ;   Beavx.                                                                
 ; 
 (DEFUN C:BEAVX (/ bstr)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq bstr "XXXXX")
  (beav bstr ())
  (setq pa (getpoint "Point: "))
  (command ".insert" "beaver" pa 1 "" 0)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Beav.                                                                 
 ; 
 (DEFUN C:BEAV (/ bstr)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq bstr (Getstring T "Engineer: "))
  (beav bstr ())
  (setq pa (getpoint "Point: "))
  (command ".insert" "beaver" pa 1 "" 0)
  (command "undo" "end")
 (princ))